
// Check if an element has a specific data attribute
//
jQuery.fn.hasDataAttr = function(name) {
  return $(this)[0].hasAttribute('data-'+ name);
};



// Get data attribute. If element doesn't have the attribute, return default value
//
jQuery.fn.dataAttr = function(name, def) {
  return $(this)[0].getAttribute('data-'+ name) || def;
};



// Return outerHTML (inclusing the element) code
//
jQuery.fn.outerHTML = function() {
  var html = '';
  this.each(function(){
    html += $(this).prop("outerHTML");
  })
  return html;
};


// Return HTML code of all the selected elements
//
jQuery.fn.fullHTML = function() {
  var html = '';
  $(this).each(function(){
    html += $(this).outerHTML();
  });
  return html;
};

// Instance search
//
// $.expr[':'] -> $.expr.pseudos
jQuery.expr[':'].search = function(a, i, m) {
  return $(a).html().toUpperCase().indexOf(m[3].toUpperCase()) >= 0;
};


// Scroll to end
//
jQuery.fn.scrollToEnd = function() {
  $(this).scrollTop( $(this).prop("scrollHeight") );
  return this;
};
